import pandas as pd
import numpy as np
import pickle

atp_tennis = pd.read_csv('atp_tennis.csv')

def calculate_head_to_head_win_rate(data):  
    unique_players = pd.concat([data['Player_1'], data['Player_2']]).unique()  
  
    total_matches = data.groupby(['Player_1', 'Player_2']).size().reset_index().rename(columns={0: 'count_total'})  
    player_wins = data[data['Winner'] == data['Player_1']].groupby(['Player_1', 'Player_2']).size().reset_index().rename(columns={0: 'count_wins'})  
  
    all_pairs = pd.MultiIndex.from_product([unique_players, unique_players], names=['Player', 'Opponent']).to_frame(index=False)  
    all_pairs = all_pairs[all_pairs['Player'] != all_pairs['Opponent']]  
      
    h2h_win_rates = all_pairs.merge(total_matches, left_on=['Player', 'Opponent'], right_on=['Player_1', 'Player_2'], how='left').drop(columns=['Player_1', 'Player_2'])  
    h2h_win_rates = h2h_win_rates.merge(player_wins, left_on=['Player', 'Opponent'], right_on=['Player_1', 'Player_2'], how='left').drop(columns=['Player_1', 'Player_2'])  
  
    h2h_win_rates['count_wins'].fillna(0, inplace=True)  
    h2h_win_rates['count_total'].fillna(1, inplace=True)  
    h2h_win_rates['Head-to-Head Win Rate'] = h2h_win_rates['count_wins'] / h2h_win_rates['count_total']  
  
    h2h_win_rates.drop(columns=['count_total', 'count_wins'], inplace=True)  
  
    return h2h_win_rates   
